package twirptimotyenservice

import (
	"context"
	"testing"

	"code.justin.tv/timotyenorg/timotyenservice/proto/timotyenservice"
)

func TestTimotyenserviceImpl_ItemGet(t *testing.T) {
	e := TimotyenserviceImpl{
		SecretKey: "hi",
	}
	resp, err := e.ItemGet(context.Background(), &timotyenservice.ItemGetRequest{
		Key: "hi",
	})
	if err != nil {
		t.Error("expected no error")
	}
	if resp.Value != "YOU GUESSED THE SECRET KEY" {
		t.Error("You should be able to guess the secret key")
	}
}

func TestTimotyenserviceImpl_ItemError(t *testing.T) {
	e := TimotyenserviceImpl{
		SecretKey: "hi",
	}
	_, err := e.ItemGet(context.Background(), &timotyenservice.ItemGetRequest{
		Key: "-downstream_failure-",
	})
	if err == nil {
		t.Error("expected an error")
	}
}
