#!/bin/bash

DIR="${BASH_SOURCE%/*}"
if [[ ! -d "$DIR" ]]; then DIR="$PWD"; fi

. "$DIR/bastion.sh"
. "$DIR/ecs.sh"
. "$DIR/bootstrap.sh"
. "$DIR/builder.sh"
. "$DIR/common.sh"
. "$DIR/docker.sh"
. "$DIR/extra.sh"
. "$DIR/go.sh"
. "$DIR/infra.sh"
. "$DIR/twinit.sh"
. "$DIR/credential_process.sh"
if [[ "${INFRA_VERSION-1}" == "1" ]]; then
  . "$DIR/deprecated_infra.sh"
fi

custom_dir="${DIR}/../custom"
if [[ -d "${custom_dir}" ]]; then
  for f in ${custom_dir}/*.sh; do
    source $f
  done
fi
