#!/bin/bash

function root__go() {
  if [[ "${1-}" == "help" ]]; then
    echo "Runs go related commands"
    exit 0
  fi
  process_build go__ $@
}

function go__lint() {
  if [[ "${1-}" == "help" ]]; then
    echo "Runs gometalinter to lint your project"
    exit 0
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    make_exec builder run go lint $@
  fi
  golangci-lint run
}

function go__build() {
  if [[ "${1-}" == "help" ]]; then
    echo "Build your go service locally"
    exit 0
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    make_exec builder run go build $@
  fi
  go build -mod vendor ./cmd/${SERVICE}/
}

function go__run() {
  # TODO: Verify the bastion tunnel is setup and fail fast if not
  if [[ "${1-}" == "help" ]]; then
    echo "Build then run the service locally"
    exit 0
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    if [[ ! -z "${LOCAL_GO_RUN_DOCKER_ARGS-}" ]]; then
      # Note: must export this to be picked up by lower exec call
      export LOCAL_DOCKER_RUN_ARGS="${LOCAL_DOCKER_RUN_ARGS-} ${LOCAL_GO_RUN_DOCKER_ARGS}"
    fi
    make_exec builder run go run $@
  fi
  make_run go build
  (
    AWS_PROFILE="staging-deploy" assume_role --role-arn ${LOCAL_DEV_ROLE} --role-session-name "go_run"
    populate_app_env
    ./${SERVICE} $@
  )
}

function go__integration_test() {
  if [[ "${1-}" == "help" ]]; then
    echo "Run integration tests locally"
    exit 0
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    make_exec builder run go integration_test $@
  fi
  (
    AWS_PROFILE="staging-deploy" assume_role --role-arn ${LOCAL_DEV_ROLE} --role-session-name "go_run"
    populate_app_env
    go test -count=1 -mod vendor -v -timeout ${INTEGRATION_TEST_TIMEOUT} -race -run="TestIntegration" -tags=integration ./...
  )
}

function go__test() {
  if [[ "${1-}" == "help" ]]; then
    echo "Run the service's Go unit tests"
    exit 0
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    make_exec builder run go test $@
  fi
  go test -count=1 -mod vendor -race -cover -coverprofile=coverage.txt -covermode=atomic -timeout 30s ./...
}

function go__format() {
  if [[ "${1-}" == "help" ]]; then
    echo "Reformat all go files"
    exit 0
  fi
  if [[ "${USE_BUILDER}" == "true" ]]; then
    make_exec builder run go format $@
  fi
  find . -iname '*.go' -not -path '*/vendor/*' -not -path '*/_tools/*' -print0 | xargs -0 gofmt -s -w
  find . -iname '*.go' -not -path '*/vendor/*' -not -path '*/_tools/*' -print0 | xargs -0 env GO111MODULE=off goimports -w
}