# twirpserviceslohook
[![GoDoc](https://img.shields.io/badge/godoc-reference-5272B4.svg?style=flat-square)](https://godoc.internal.justin.tv/code.justin.tv/hygienic/twirpserviceslohook)
[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=hygienic/twirpserviceslohook/master)](https://jenkins.internal.justin.tv/job/hygienic/job/twirpserviceslohook/job/master/)

twirpserviceslohook helps track twirp SLO metrics

# Example

```go
	stat := &statsd.NoopClient{}
	t := twirpserviceslohook.TwirpSLOTracker {
		SLO: map[twirpserviceslohook.ServiceName]map[twirpserviceslohook.MethodName]time.Duration{
			"Haberdasher": {
				"MakeHat": time.Millisecond * 50,
			},
		},
		DefaultSLO: time.Millisecond * 100,
		StatTracker: &statsdslo.StatTracker {
			Statter: stat,
		},
	}
	rpc.NewHaberdasherServer(nil, t.ServerHook())
```

# Generator

`slogenerator` is a tool you can use to auto extract SLO measurements from protobuf definitions

1. Add a comment to your protobuf method

```proto
service Graffiti {
 	// GetTag hydrates a tag ID into a tag object.
	// SLO@150ms
 	rpc GetTag(GetTagRequest) returns (GetTagResponse);
}
```

2. Generate a twirp Go implementation from your service protobuf
3. Create an slo.go file from your twirp go implementation
```bash
slogenerator rpc/graffiti/service.twirp.go graffiti > rpc/graffiti/slo.go
```

This will create a file, slo.go, that contains your SLO timings which you can use by this library.

```go
// Code generated by slogenerator. DO NOT EDIT.
package graffiti

import (
	"time"

	"code.justin.tv/hygienic/twirpserviceslohook"
)

var _ twirpserviceslohook.ServiceName = ""
var _ time.Duration = time.Second

// SLOGraffiti is auto generated and helps track method call SLO
var SLOGraffiti = map[twirpserviceslohook.ServiceName]map[twirpserviceslohook.MethodName]time.Duration{
	twirpserviceslohook.ServiceName("Graffiti"): {
		twirpserviceslohook.MethodName("CreateContentTags"):  150000000,
		twirpserviceslohook.MethodName("CreateTag"):          100000000,
		twirpserviceslohook.MethodName("DeleteContentTags"):  150000000,
		twirpserviceslohook.MethodName("EnsureTagExists"):    200000000,
		twirpserviceslohook.MethodName("GetBulkContentTags"): 100000000,
		twirpserviceslohook.MethodName("GetBulkTags"):        200000000,
		twirpserviceslohook.MethodName("GetContentTags"):     200000000,
		twirpserviceslohook.MethodName("GetTag"):             150000000,
		twirpserviceslohook.MethodName("UpdateContentTags"):  200000000,
		twirpserviceslohook.MethodName("UpdateTag"):          150000000,
	},
}
```
