package events

import (
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/cactus/go-statsd-client/statsd"
)

// DefaultableEvent is an event that can defaults for another event
type DefaultableEvent interface {
	FillDefaults(other interface{})
}

// EventWriter writes events
type EventWriter interface {
	WriteEvent(interface{})
	WithFields(DefaultableEvent) EventWriter
}

// EventWriterClient describes a client that implements EventWriter
type EventWriterClient interface {
	EventWriter
	Run()
	Init(*session.Session, statsd.Statter) error
	Close() error
}
