/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import com.unity3d.player.a;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.cert.CertPathValidatorException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

class UnityWebRequest
implements Runnable {
    private long a;
    private String b;
    private String c;
    private Map d;
    private int e;
    private long f;

    UnityWebRequest(long l2, String string, Map map, String string2, int n2) {
        this.a = l2;
        this.b = string2;
        this.c = string;
        this.d = map;
        this.e = n2;
    }

    private boolean hasTimedOut() {
        if (this.e <= 0) {
            return false;
        }
        return System.currentTimeMillis() - this.f >= (long)this.e;
    }

    @Override
    public void run() {
        try {
            this.runSafe();
            return;
        }
        catch (Exception exception) {
            this.errorCallback(exception.toString());
            return;
        }
    }

    private void runSafe() {
        Iterator iterator;
        URLConnection uRLConnection;
        Object object2;
        this.f = System.currentTimeMillis();
        try {
            object2 = new URL(this.b);
            uRLConnection = ((URL)object2).openConnection();
            uRLConnection.setConnectTimeout(this.e);
            uRLConnection.setReadTimeout(this.e);
            if (uRLConnection instanceof HttpsURLConnection && (iterator = com.unity3d.player.a.a()) != null) {
                ((HttpsURLConnection)uRLConnection).setSSLSocketFactory((SSLSocketFactory)((Object)iterator));
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.malformattedUrlCallback(malformedURLException.toString());
            return;
        }
        catch (IOException iOException) {
            this.errorCallback(iOException.toString());
            return;
        }
        if (((URL)object2).getProtocol().equalsIgnoreCase("file") && !((URL)object2).getHost().isEmpty()) {
            this.malformattedUrlCallback("file:// must use an absolute path");
            return;
        }
        if (uRLConnection instanceof HttpURLConnection) {
            try {
                iterator = (HttpURLConnection)uRLConnection;
                ((HttpURLConnection)((Object)iterator)).setRequestMethod(this.c);
                ((HttpURLConnection)((Object)iterator)).setInstanceFollowRedirects(false);
            }
            catch (ProtocolException protocolException) {
                this.badProtocolCallback(protocolException.toString());
                return;
            }
        }
        if (this.d != null) {
            for (Map.Entry object3 : this.d.entrySet()) {
                uRLConnection.addRequestProperty((String)object3.getKey(), (String)object3.getValue());
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(131072);
        if (this.uploadCallback(null) > 0) {
            uRLConnection.setDoOutput(true);
            try {
                object2 = uRLConnection.getOutputStream();
                int n2 = this.uploadCallback(byteBuffer);
                while (n2 > 0) {
                    if (this.hasTimedOut()) {
                        ((OutputStream)object2).close();
                        UnityWebRequest.errorCallback(this.a, 14, "WebRequest timed out.");
                        return;
                    }
                    ((OutputStream)object2).write(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
                    n2 = this.uploadCallback(byteBuffer);
                }
            }
            catch (Exception exception) {
                this.errorCallback(exception.toString());
                return;
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            object2 = (HttpURLConnection)uRLConnection;
            try {
                int n3 = ((HttpURLConnection)object2).getResponseCode();
                this.responseCodeCallback(n3);
            }
            catch (UnknownHostException unknownHostException) {
                this.unknownHostCallback(unknownHostException.toString());
                return;
            }
            catch (SSLException sSLException) {
                this.sslCannotConnectCallback(sSLException);
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                UnityWebRequest.errorCallback(this.a, 14, socketTimeoutException.toString());
                return;
            }
            catch (IOException iOException) {
                this.errorCallback(iOException.toString());
                return;
            }
        }
        object2 = uRLConnection.getHeaderFields();
        this.headerCallback((Map)object2);
        if (!(object2 != null && object2.containsKey("content-length") || uRLConnection.getContentLength() == -1)) {
            this.headerCallback("content-length", String.valueOf(uRLConnection.getContentLength()));
        }
        if (!(object2 != null && object2.containsKey("content-type") || uRLConnection.getContentType() == null)) {
            this.headerCallback("content-type", uRLConnection.getContentType());
        }
        int n4 = uRLConnection.getContentLength();
        this.contentLengthCallback(n4);
        try {
            InputStream inputStream = null;
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                this.responseCodeCallback(httpURLConnection.getResponseCode());
                inputStream = httpURLConnection.getErrorStream();
            }
            if (inputStream == null) {
                inputStream = uRLConnection.getInputStream();
            }
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            int n5 = readableByteChannel.read(byteBuffer);
            while (n5 != -1) {
                if (this.hasTimedOut()) {
                    readableByteChannel.close();
                    UnityWebRequest.errorCallback(this.a, 14, "WebRequest timed out.");
                    return;
                }
                if (!this.downloadCallback(byteBuffer, n5)) break;
                byteBuffer.clear();
                n5 = readableByteChannel.read(byteBuffer);
            }
            readableByteChannel.close();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.unknownHostCallback(unknownHostException.toString());
            return;
        }
        catch (SSLException sSLException) {
            this.sslCannotConnectCallback(sSLException);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            UnityWebRequest.errorCallback(this.a, 14, socketTimeoutException.toString());
            return;
        }
        catch (IOException iOException) {
            UnityWebRequest.errorCallback(this.a, 14, iOException.toString());
            return;
        }
        catch (Exception exception) {
            this.errorCallback(exception.toString());
            return;
        }
    }

    private static native void headerCallback(long var0, String var2, String var3);

    protected void headerCallback(String string, String string2) {
        UnityWebRequest.headerCallback(this.a, string, string2);
    }

    protected void headerCallback(Map object) {
        if (object == null || object.size() == 0) {
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            if (string == null) {
                string = "Status";
            }
            for (String string2 : (List)entry.getValue()) {
                this.headerCallback(string, string2);
            }
        }
    }

    private static native int uploadCallback(long var0, ByteBuffer var2);

    protected int uploadCallback(ByteBuffer byteBuffer) {
        return UnityWebRequest.uploadCallback(this.a, byteBuffer);
    }

    private static native void contentLengthCallback(long var0, int var2);

    protected void contentLengthCallback(int n2) {
        UnityWebRequest.contentLengthCallback(this.a, n2);
    }

    private static native boolean downloadCallback(long var0, ByteBuffer var2, int var3);

    protected boolean downloadCallback(ByteBuffer byteBuffer, int n2) {
        return UnityWebRequest.downloadCallback(this.a, byteBuffer, n2);
    }

    protected void responseCodeCallback(int n2) {
        UnityWebRequest.responseCodeCallback(this.a, n2);
    }

    private static native void responseCodeCallback(long var0, int var2);

    protected void unknownHostCallback(String string) {
        UnityWebRequest.errorCallback(this.a, 7, string);
    }

    protected void badProtocolCallback(String string) {
        UnityWebRequest.errorCallback(this.a, 4, string);
    }

    protected void malformattedUrlCallback(String string) {
        UnityWebRequest.errorCallback(this.a, 5, string);
    }

    protected void sslCannotConnectCallback(SSLException throwable) {
        String string = throwable.toString();
        int n2 = 16;
        while (throwable != null) {
            if (throwable instanceof SSLKeyException) {
                n2 = 23;
                break;
            }
            if (throwable instanceof SSLPeerUnverifiedException || throwable instanceof CertPathValidatorException) {
                n2 = 25;
                break;
            }
            throwable = throwable.getCause();
        }
        UnityWebRequest.errorCallback(this.a, n2, string);
    }

    protected void errorCallback(String string) {
        UnityWebRequest.errorCallback(this.a, 2, string);
    }

    private static native void errorCallback(long var0, int var2, String var3);

    static {
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
    }
}

