# Twitch in Games SDK

This is the main repository for the **Twitch in Games SDK**, a library to provide access to Twitch features and services through an API targeted at applications (primarily games) used by streamers on Twitch.

There are two versions of the API.  One is in C++ and is intended for native use in Windows, Xbox One, and PlayStation 4.  The other is in C# and is intended for scripting use in Unity.

The latter is not a complete re-implementation of the former.  The C# implementation makes use of the C++ implementation, where appropriate, to perform platform-specific operations.  It also makes use of platform-specific (e.g. iOS and Android) implementations.

## Set-up

### Windows

This repository has used symbolic links in the past.  To successfully view the history of this repository, you must install at least version 2.16 of **git** on Windows and include the following in your `.gitconfig` file in your home directory.

```
[core]
	symlinks = true
```

Depending on your installation, you might also need this in your `.gitconfig` file.

```
[url "git@git-aws.internal.justin.tv:"]
	insteadOf = https://git-aws.internal.justin.tv/
```

Install **Visual Studio 2017** and **Unity 2017.3**.  See the [UnityApp1 read-me file](external/UnityApp1/README.md) for additional installations, depending on what parts of the SDK you want to build.

To build and run the test project in the solution, install the following:

 * [Google Test Adapter for Visual Studio](https://marketplace.visualstudio.com/items?itemName=ChristianSoltenborn.GoogleTestAdapter)

### Mac

The following are required due to the [CAPE SDK](/sdk/sdk).

1. Install [brew](https://brew.sh).
2. Run `brew install python@2` to install **Python 2**.
3. Run `pip install --upgrade pip` to upgrade **Pip**.
4. Run `pip install gitpython` to install Git for **Python 2**.
5. Install [cmake](https://cmake.org/download/).
6. Run `sudo /Applications/CMake.app/Contents/bin/cmake-gui --install`.

If you have issues, see the [CAPE SDK Build read-me](/sdk/sdk/blob/master/docs/Build.md).
