﻿#pragma once

#include "TwitchInGames.h"
#include "StepTimer.h"
#include "DeviceResources.h"
#include "SceneRenderer.h"
#include "FpsTextRenderer.h"

// Renders Direct2D and 3D content on the screen.
namespace DirectX11App1 {
	class Main : public DX::IDeviceNotify {
	public:
		std::wstring authenticationToken;

		Main(std::shared_ptr<DX::DeviceResources> const& deviceResources);
		~Main();
		void CreateWindowSizeDependentResources();
		void Update();
		bool Render();
		TwitchInGames::tstring PerformServerAuth();

		// IDeviceNotify
		virtual void OnDeviceLost();
		virtual void OnDeviceRestored();

	private:
		// Cached pointer to device resources.
		std::shared_ptr<DX::DeviceResources> m_deviceResources;

		// TODO: Replace with your own content renderers.
		std::unique_ptr<Sample3DSceneRenderer> m_sceneRenderer;
		std::unique_ptr<SampleFpsTextRenderer> m_fpsTextRenderer;

		// Rendering loop timer.
		DX::StepTimer m_timer;
	};
}
