@ECHO OFF
SETLOCAL

FOR /F %%I IN ('TYPE "%~dp0..\version.txt"') DO SET FILE_NAME=TwitchInGames.%%I.zip
IF "%FILE_NAME%" == "" (
	ECHO Cannot find version.txt
	EXIT /B 1
)

IF "%~1" == "" GOTO make
SET D=%~1
SET P="%D%\..\AppPackages\%FILE_NAME%"

IF NOT EXIST %P% (
	ECHO Build and package the SDK first.
	EXIT /B 1
)

"\Program Files\7-Zip\7z.exe" x -aoa "-o%D%\bin" %P%
EXIT /B %ERRORLEVEL%

:make
CD /D "%~dp0"
cscript //nologo "%~n0.js" %FILE_NAME% Package.mak
nmake -nologo -f Package.mak
SET EXIT_CODE=%ERRORLEVEL%
DEL /F /Q Package.mak
EXIT /B %EXIT_CODE%
