﻿using UnityEditor;
using UnityEngine;

namespace TwitchInGames.Test {
    public class Build {

        private static BuildPlayerOptions buildPlayerOptions = new BuildPlayerOptions();
        private static string path = string.Format("{0}/../Builds/", Application.dataPath);
        private static string[] scenes = new[] { "Assets/Scenes/AuthTest.unity",
                                             "Assets/Scenes/UnitTest_User.unity",
                                             "Assets/Scenes/UnitTest_Chat.unity",
                                             "Assets/Scenes/UnitTest_Clip.unity",
                                             "Assets/Scenes/UnitTest_Stream.unity",
                                             "Assets/Scenes/UnitTest_Follow.unity"};

        [MenuItem("TwitchInGames/Build Current Platform")]
        public static void BuildCurrent() {
            InternalBuild(EditorUserBuildSettings.activeBuildTarget);
        }

        private static void InternalBuild(BuildTarget target) {
            if(EditorUserBuildSettings.activeBuildTarget != target) {
                SwitchPlatform.Switch(target);
            }

            buildPlayerOptions.scenes = scenes;
            switch(target) {
            case BuildTarget.iOS:
                buildPlayerOptions.locationPathName = path + "UnityApp1";
                break;
            case BuildTarget.StandaloneWindows64:
                buildPlayerOptions.locationPathName = path + "UnityApp1.exe";
                break;
            case BuildTarget.Android:
                buildPlayerOptions.locationPathName = path + "UnityApp1.apk";
                break;
            default:
                break;
            }
            buildPlayerOptions.target = target;
            buildPlayerOptions.options = BuildOptions.AutoRunPlayer;
            BuildPipeline.BuildPlayer(buildPlayerOptions);

            Debug.Log("[TwitchInGames] Built " + target.ToString() + " : " + buildPlayerOptions.locationPathName.Replace("/Assets/..", ""));
        }
    }
}
