﻿using UnityEditor;
using UnityEngine;

namespace TwitchInGames {
    public class TwitchSettingMenuItem : MonoBehaviour {

        [MenuItem("TwitchInGames/Twitch Setting")]
        public static void TwitchSetting() {
            var twitchSettings = Resources.Load("TwitchSettings") as TwitchSettings;
            if(twitchSettings == null) {
                twitchSettings = CreateTwitchSettings();
            }

            EditorUtility.FocusProjectWindow();
            Selection.activeObject = twitchSettings;
        }

        private static TwitchSettings CreateTwitchSettings() {
            var twitchSettings = ScriptableObject.CreateInstance<TwitchSettings>();
            AssetDatabase.CreateAsset(twitchSettings, "Assets/Resources/TwitchSettings.asset");
            AssetDatabase.SaveAssets();
            return twitchSettings;
        }
    }
}
