// https://answers.unity.com/questions/982417/how-to-specify-objc-in-other-linker-flag-in-xcode.html
// https://bitbucket.org/Unity-Technologies/iosnativecodesamples/src/a0bc90e7d6358e456caf25d717134864218740a7/NativeIntegration/Misc/UpdateXcodeProject/Assets/Editor/XcodeProjectUpdater.cs

#if UNITY_IOS
using System.Collections;
using System.IO;
using UnityEditor;
using UnityEditor.Callbacks;
using UnityEditor.iOS.Xcode;
using UnityEngine;

public class XcodeProjectUpdater {
	[PostProcessBuild]
	public static void OnPostprocessBuild(BuildTarget buildTarget, string path) {
		if(buildTarget == BuildTarget.iOS) {
			string projectPath = path + "/Unity-iPhone.xcodeproj/project.pbxproj";
			var project = new PBXProject();
			project.ReadFromString(File.ReadAllText(projectPath));
			string target = project.TargetGuidByName("Unity-iPhone");
			project.AddBuildProperty(target, "OTHER_LDFLAGS", "-ObjC -lz");
			File.WriteAllText(projectPath, project.WriteToString());
		}
	}
}
#endif
