﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

namespace TwitchInGames.Test {
    public class InfoHolder : MonoBehaviour {
#pragma warning disable 649 // Field '*' is never assigned to, and will always have its default value *
        [SerializeField]
        private GameObject messagePrefab;

        private Message message;
#pragma warning restore 649

        public void Init(Dictionary<string, string> fields) {
            foreach(var field in fields) {
                if(message == null) {
                    GameObject gameobject = Instantiate(messagePrefab, transform);
                    message = gameobject.GetComponent<Message>();
                }                
                message.Init(new string[] { field.Key, field.Value });
            }
        }
    }
}
