﻿using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

namespace TwitchInGames.Test {
    public class StaticCanvas : MonoBehaviour {
#pragma warning disable 649 // Field '*' is never assigned to, and will always have its default value *
        [SerializeField]
        private Dropdown sceneList;
#pragma warning restore 649

        private static StaticCanvas instance;

        private void Awake() {
            if(instance == null) {
                instance = this;
                DontDestroyOnLoad(this);
            } else {
                Destroy(gameObject);
            }
#if !UNITY_ANDROID && !UNITY_IOS
            Screen.SetResolution(768, 1024, false);
#endif
        }

        public void SwitchScene() {
            SceneManager.LoadScene(sceneList.captionText.text, LoadSceneMode.Single);
        }
    }
}
