﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace TwitchInGames.Test {
    public class StreamInfoHolder : InfoHolder {
#pragma warning disable 649 // Field '*' is never assigned to, and will always have its default value *
        [SerializeField]
        private Image thumbnail;
#pragma warning restore 649

        public void Init(string thumbnailUrl, Dictionary<string, string> fields) {
            StartCoroutine(DisplayThumbnail(thumbnailUrl));
            base.Init(fields);
        }

        private IEnumerator DisplayThumbnail(string url) {
            WWW www = new WWW(url);
            yield return www;
            thumbnail.sprite = Sprite.Create(www.texture, new Rect(0, 0, www.texture.width, www.texture.height), new Vector2(0, 0));
        }
    }
}
