﻿using System;
using UnityEngine;

namespace TwitchInGames {
    public class TwitchSettings : ScriptableObject {

#pragma warning disable 649 // Field '*' is never assigned to, and will always have its default value *
        [SerializeField]
        private string clientID;
#pragma warning restore 649

        public string ClientID {
            get {
                if(String.IsNullOrEmpty(clientID)) {
                    throw new ArgumentNullException("Client ID");
                }
                return clientID;
            }
        }
    }
}
