﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace TwitchInGames.Test {
    public abstract class UnitTest_Auth : MonoBehaviour {

        protected static string redirectUri = "twig://twig.tv/auth";
        protected static string clientId; //dviaxdls39mj44cdnei76mj2dlig33

        protected string authToken;
        protected ClientAuth clientAuth;

#pragma warning disable 649 // Field '*' is never assigned to, and will always have its default value *
        [SerializeField]
        private List<string> scopes;

        [SerializeField]
        protected Text output;

        [SerializeField]
        protected Text outputClientId;

        [SerializeField]
        protected Text outputToken;
#pragma warning restore 649

        private void Awake() {
            if(clientId == null) {
                clientId = Resources.Load<TwitchSettings>("TwitchSettings").ClientID;
            }
        }

        protected virtual void Start() {
            outputClientId.text = clientId;
        }

        private void OnDestroy() {
            if(clientAuth != null) {
                clientAuth.Cancel();
#if UNITY_ANDROID
                Destroy(clientAuth);
#else
                clientAuth.Dispose();
#endif
            }
        }

        public virtual void GetAuthToken() {
            StartCoroutine(InternalGetAuthToken());
        }

        public virtual void GetNewUserNext() {
            StartCoroutine(InternalGetAuthToken(isNewUser: true));
        }

        private IEnumerator InternalGetAuthToken(bool isNewUser = false) {
            if(clientAuth == null) {
#if UNITY_ANDROID
                clientAuth = gameObject.AddComponent<ClientAuth>();
                var margins = new RectOffset { left = 15, top = Screen.height / 3, right = 15, bottom = Screen.height / 8 };
                yield return clientAuth.StartAuth(clientId, redirectUri, scopes, margins);
                authToken = clientAuth.AccessToken;
                if(isNewUser) {
                    clientAuth.ClearCookies();
                }
                Destroy(clientAuth);
                clientAuth = null;
#else
                clientAuth = new ClientAuth();
                authToken = null;
#if UNITY_IOS
                var margins = new RectOffset { left = 15, top = Screen.height / 8, right = 15, bottom = Screen.height / 8 };
                var coroutine = clientAuth.StartAuth(clientId, redirectUri, scopes, margins);
#else
                var coroutine = clientAuth.StartAuth(clientId, redirectUri, scopes);
#endif
                yield return coroutine;
                try {
                    authToken = coroutine.Value;
                } catch(Exception ex) {
                    Debug.LogException(ex);
                }
                clientAuth.Dispose();
                clientAuth = null;
#endif
                if(String.IsNullOrEmpty(authToken)) {
                    outputToken.text = "Failed to authorize!";
                } else {
                    outputToken.text = authToken;
                    Debug.Log("Got Auth Token: " + authToken);
                }
            }
        }
    }
}
