﻿using System;
using System.Collections;
using System.Linq;
using System.Text;
using UnityEngine;
using UnityEngine.UI;

namespace TwitchInGames.Test {
    public class UnitTest_Clip : UnitTest_Auth {
#pragma warning disable 649 // Field '*' is never assigned to, and will always have its default value *
        [SerializeField]
        private Text inputBroadcast;
        [SerializeField]
        private InputField inputBroadcastField;
#pragma warning restore 649

        public void FetchClip() {
            StartCoroutine(InternalFetchClip());
        }

        public void CreateClip() {
            if(String.IsNullOrEmpty(authToken)) {
                output.text = "Auth Token is null.\nPlease call GetAuthToken first.";
            } else {
                StartCoroutine(InternalCreateClip());
            }
        }

        private IEnumerator InternalFetchClip() {
            var coroutine = Clip.Fetch(clientId, inputBroadcast.text);
            yield return coroutine;
            try {
                var clip = coroutine.Value;
                OnFetchClip(clip);
            } catch(Exception ex) {
                Debug.LogErrorFormat("FetchClip error: {0}", ex);
            }
        }

        private IEnumerator InternalCreateClip() {
            string boradcastId = inputBroadcast.text;
            if(!boradcastId.All(Char.IsDigit)) {
                var fetchCoroutine = User.FetchOtherByLogin(clientId, boradcastId);
                yield return fetchCoroutine;
                try {
                    boradcastId = fetchCoroutine.Value.Id;
                } catch(Exception ex) {
                    Debug.LogErrorFormat("User.FetchOtherByLogin in CreateClip error: {0}", ex);
                }
            }

            var coroutine = Clip.Create(clientId, authToken, boradcastId);
            yield return coroutine;
            try {
                var clipID = coroutine.Value;
                OnCreatedClip(clipID);
            } catch(Exception ex) {
                Debug.LogErrorFormat("CreateClip error: {0}", ex);
            }
        }

        private void OnFetchClip(Clip clip) {
            if(String.IsNullOrEmpty(clip.Id)) {
                output.text = "Failed to fetch clip!";
                return;
            }

            output.text = "";
            StringBuilder sb = new StringBuilder();
            sb.Append("ID: " + clip.Id);
            sb.AppendLine();
            sb.Append("Url: " + clip.Url);
            sb.AppendLine();
            sb.Append("Embed Url: " + clip.EmbedUrl);
            sb.AppendLine();
            sb.Append("Broadcaster Id: " + clip.BroadcasterId);
            sb.AppendLine();
            sb.Append("Creator Id: " + clip.CreatorId);
            sb.AppendLine();
            sb.Append("Video Id: " + clip.VideoId);
            sb.AppendLine();
            sb.Append("Game Id: " + clip.GameId);
            sb.AppendLine();
            sb.Append("Language: " + clip.Language);
            sb.AppendLine();
            sb.Append("Title: " + clip.Title);
            sb.AppendLine();
            sb.Append("View Count: " + clip.ViewCount);
            sb.AppendLine();
            sb.Append("Created At: " + clip.CreatedAt);
            sb.AppendLine();
            sb.Append("Thumbnail Url: " + clip.ThumbnailUrl);

            Application.OpenURL(clip.EmbedUrl);

            output.text = sb.ToString();
        }

        private void OnCreatedClip(string clipID) {
            if(String.IsNullOrEmpty(clipID)) {
                output.text = "Failed to create clip!";
                return;
            }

            output.text = "";
            StringBuilder sb = new StringBuilder();
            sb.Append("Clip created: " + clipID);

            output.text = sb.ToString();
            inputBroadcastField.text = clipID;
        }
    }
}
