﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace TwitchInGames.Test {
    public class UnitTest_Stream : UnitTest_Auth {
#pragma warning disable 649 // Field '*' is never assigned to, and will always have its default value *
        [SerializeField]
        private GameObject streamInfoPrefab;

        [SerializeField]
        private GameObject messagePrefab;

        [SerializeField]
        private GameObject outputPanel;

        [SerializeField]
        private Slider firstSlider;

        [SerializeField]
        private Dropdown cursorDropdown;

        [SerializeField]
        private InputField cursor;

        [SerializeField]
        private InputField communityId;

        [SerializeField]
        private InputField gameId;

        [SerializeField]
        private InputField language;

        [SerializeField]
        private InputField userId;

        [SerializeField]
        private InputField userLogin;
#pragma warning restore 649

        public void GetStreams() {
            StartCoroutine(InternalGetStreams());
        }

        private IEnumerator InternalGetStreams() {
            var direction = StreamsRequest.PaginationDirection.None;
            if(cursorDropdown.value == 0) {
                direction = StreamsRequest.PaginationDirection.Forward;
            } else {
                direction = StreamsRequest.PaginationDirection.Backward;
            }
            var streamsRequest = new StreamsRequest {
                CommunityId = communityId.text,
                Count = (uint)firstSlider.value,
                Cursor = cursor.text,
                Direction = direction,
                GameId = gameId.text,
                Language = language.text,
                UserId = userId.text,
                UserLogin = userLogin.text
            };
            var coroutine = streamsRequest.Fetch(clientId, authToken);
            yield return coroutine;
            try {
                var streamsResponse = coroutine.Value;
                OnGetStreams(streamsResponse);
            } catch(Exception ex) {
                Debug.LogErrorFormat("GetStreams error: {0}", ex);
            }
        }

        private void OnGetStreams(StreamsResponse streamsResponse) {
            foreach(Transform child in outputPanel.transform) {
                Destroy(child.gameObject);
            }
            cursor.text = streamsResponse.Cursor;
            Debug.Log("Pagination: " + streamsResponse.Cursor);

            GameObject log1 = Instantiate(messagePrefab, outputPanel.transform);
            log1.GetComponent<Message>().Init(new string[] { "Log", "Got " + streamsResponse.Streams.Count.ToString() + " streams." });

            foreach(var stream in streamsResponse.Streams) {
                GameObject gameobject = Instantiate(streamInfoPrefab, outputPanel.transform);
                var url = stream.ThumbnailUrl.Replace("{width}", "300");
                url = url.Replace("{height}", "200");
                Dictionary<string, string> fields = new Dictionary<string, string>(9) {
                    { "title", stream.Title },
                    { "viewer_count", stream.ViewerCount.ToString() },
                    { "id", stream.Id },
                    { "user_id", stream.UserId },
                    { "game_id", stream.GameId },
                    { "type", stream.Type.ToString() },
                    { "started_at", stream.StartedAt.ToString() },
                    { "language", stream.Language },
                    { "community_ids", String.Join(" ", stream.CommunityIds) }
                };
                gameobject.GetComponent<StreamInfoHolder>().Init(url, fields);
            }
        }
    }
}
