# Unity example application

## iOS

Install **Xcode 9.2**.

To build the "UnityApp1" application for the first time, follow these steps.

1. In MonoDevelop, open the mono solution file, `mono.sln`, in the root SDK folder.
2. Build the solution with Command-B.
3. Plug the iPhone into your Macintosh.
4. In a terminal, run `lib/create-sdk-projects`.
5. In Xcode, open the CAPE SDK project, `twitchsdk.xcodeproj`, in the `lib/external` sub-folder.
6. Build the project with Command-B.
7. In Xcode, open the Unity iOS project, `UnityiOS.xcodeproj`, in the `lib/UnityiOS` sub-folder.
8. Build the project with Command-B.
9. In Unity, open the "UnityApp1" project.  In the "Console" tab, it will complain with an informational note and twelve errors.
10. In the "Project" tab, expand "Assets" and "Plugins" and select "iOS".
11. Click the "libUnityiOS" puzzle piece and command-click the "Unity" puzzle piece.
12. Check the "Editor" check box under "Include Platforms" and click the "Apply" button.  A single CS1501 error will replace the above twelve errors in the "Console" tab.
13. Command-click the "Unity" puzzle piece.
14. Select the iPhone settings under "Platform settings", expand "Rarely used frameworks", and check the "WebKit" check box and click the "Apply" button.
15. In the "Project" tab, select "x86\_64".
16. Click the "Unity" puzzle piece and command-click "UnityWin32" puzzle piece.
17. Clear the "Any Platform" check box under "Select platforms for plugin".  The three checkboxes under "Include Platforms" will become checked.
18. Clear all check boxes under "Include Platforms" and click the "Apply" button.
29. Open the "Build Settings" dialog with Shift-Command-B.
20. Select "iOS" for "Platform" and "Debug" for "Run in Xcode as".
21. Check the "Symlink Unity libraries", "Development Build", and "Script Debugging" check boxes.
22. Click the "Switch Platform" button.  The "Assets Progress" dialog will appear.  After it closes, an informational note will replace the error in the "Console" tab.
23. Click the "Build" button.  The "Build iOS" dialog will appear.
24. Click the expand button (next to the "Save As" text box).  The dialog will expand to display the files and folders.
25. Click the "New Folder" button.  The "New Folder" dialog will appear.
26. Enter "Builds" in the text box and click the "Create" button.  The "New Folder" dialog will close.
27. Select the newly-created `Builds` folder in the folder list in the `UnityApp1` folder.
28. Enter "UnityApp1" in the "Save As" text box and click the "Save" button.  The "Building Player" dialog will replace the "Build iOS" dialog.  After some time, a Finder window will open with the `UnityApp1` folder.
39. Double-click the "Unity-iPhone.xcodeproj" file.  Xcode will open.
30. Build the project with Command-B.

To subsequently build the "UnityApp1" application after making changes to the "UnityApp1" project in the `external/UnityApp1` folder or the "UnityiOS" project in the `lib/UnityiOS` folder, follow these steps.

1. If it's not already open, open the "UnityApp1" project in Unity.
2. Open the "Build Settings" dialog with Shift-Command-B.
3. Ensure the settings listed in steps 9 and 10 above are displayed.
4. Click the "Build" button.  The "Build iOS" dialog will appear.
5. Ensure "UnityApp1" is in the "Save As" text box and "Builds" is in the "Where" drop-down list.
6. Click the "Save" button.  A warning overlay will appear.
7. Click the "Append" button.  The "Building Player" dialog will replace the "Build iOS" dialog.  After the build completes, a Finder window will open with the `App1` folder.
8. Plug the iPhone into your Macintosh.
9. Double-click the `Unity-iPhone.xcodeproj` file.  Xcode will open.
10. Build the project with Command-B.

To build and run the "UnityApp1" application, follow these steps.

1. Plug the iPhone into your Macintosh.
2. Follow steps 1 through 3 above.
3. Click the "Build And Run" button.  The "Build iOS" dialog will appear.
4. Click the "Save" button.  A warning overlay will appear.
5. Click the "Append" button.  The "Building Player" dialog will replace the "Build iOS" dialog.
6. During the build, turn on and unlock the iPhone.
7. When the build completes, the application will open on the iPhone.

## Android

Install **Java SE SDK 8 Update 162 (64-bit)** and **Android Studio 3.0.1**.  Note that **Java SE SDK 9** will not work.

To build the "UnityApp1" application for the first time, follow these steps.

1. In Visual Studio, open the solution file, `sdk.sln`, in the root SDK folder.
2. Build the solution with Control-Shift-B.
3. In Unity, open the "UnityApp1" project.  In the "Console" tab, it will complain with two informational notes, two warnings, and an error.
4. From the "TwitchInGames" menu, select "Switch Platform" then "Android".  Seven more errors will appear in the "Console" tab.
5. In the "Project" tab, expand "Assets" and "Plugins" and select "Android".
6. Click the "Unity" puzzle piece.
7. Check the "Editor" and "Android" check boxes under "Include Platforms" and click the "Apply" button.  A single CS1704 error will replace the above seven additional errors in the "Console" tab.
8. Click the "twiglib-release" puzzle piece and control-click "Java-WebSocket-1.3.4" puzzle piece.
9. Check the "Android" and clear the "Editor" check box under "Include Platforms" and click the "Apply" button.
10. Select "x86\_64".
11. Click the "Unity" puzzle piece and control-click "UnityWin32" puzzle piece.
12. Clear the "Any Platform" check box under "Select platforms for plugin".  The three checkboxes under "Include Platforms" will become checked.
13. Clear the "Editor" and "Android" check boxes under "Include Platforms" and click the "Apply" button.  An informational note will replace the above CS1704 error in the "Console" tab.
14. Open the "Build Settings" dialog with Control-Shift-B.
15. Click the "Build" button.  The "Build Android" dialog will appear.
16. Click the "New folder" button, type "Builds", and press the "Enter" key twice.
17. In the "File name" text box, type "UnityApp1" and press the "Enter" key.  The build will succeed and an Explorer window will open with the `Builds` folder with the `UnityApp1.apk` file selected.

To subsequently build the "UnityApp1" application after making changes to the "UnityApp1" project in the `external/UnityApp1` folder or the "UnityAndroid" project in the `lib/UnityAndroid` folder, follow these steps.

1. If it's not already open, open the "UnityApp1" project in Unity.
2. Open the "Build Settings" dialog with Control-Shift-B.
3. Ensure the settings listed in step 9 above in the first set of instructions are displayed.
4. Click the "Build" button.  The "Build Android" dialog will appear.
5. Ensure "UnityApp1.apk" is displayed in the "File name" text box and the current folder path ends with "Builds".
6. Click the "Save" button.  The "Confirm Save As" dialog will appear.
7. Click the "Yes" button.  A progress dialog will appear followed by an Explorer window open with the `Builds` folder.
