@echo off

set EDITORPATH=C:\Program Files\Unity\Editor\Unity.exe

IF NOT EXIST "%EDITORPATH%" (
	echo %EDITORPATH% does not exist
	goto fail
)

IF NOT EXIST "%PROJECTPATH%" (
	echo %PROJECTPATH% does not exist
	goto fail
)

echo Building Unity on Windows
"%EDITORPATH%" -quit -batchmode -projectPath "%PROJECTPATH%" -quit -batchmode -executeMethod Build.BuildWin -logFile "%BUILDPATH%log_win.txt"

if ERRORLEVEL 1 goto fail

echo Building Unity on Android
"%EDITORPATH%" -quit -batchmode -projectPath "%PROJECTPATH%" -quit -batchmode -executeMethod Build.BuildAndroid -logFile "%BUILDPATH%log_android.txt"

if ERRORLEVEL 1 goto fail

:success
echo SUCCESS
exit /b 0

:fail
echo FAIL
exit /b 1