// TWIG SDK Jenkins

// Modified from https://git.xarth.tv/release/jenkins-jobs/blob/master/templates/autobuild.groovy
job('TEMPLATE-twig-sdk-common') {
    concurrentBuild true
    configure { project ->
        project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
        project / publishers / 'org.jenkinsci.plugins.github.status.GitHubCommitStatusSetter' {
            commitShaSource(class: "org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource")
            reposSource(class: "org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource")
            contextSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource")
            statusResultSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultStatusResultSource")
        }
    }
    wrappers {
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }
}


// The regular Windows job that picks up commits in branches
job('twig-sdk-windows-build-commit') {
    label 'games-app'
    using 'TEMPLATE-twig-sdk-common'
    description 'Builds all Windows artifacts upon any push to any branch in twig/sdk.'
    triggers {
        githubPush()
    }
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    scm {
        git {
            remote {
                github 'twig/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        batchFile '%WORKSPACE%\\jenkins\\cmd\\build_as_config.cmd'
    }
}


// The regular iOS job that picks up commits in branches
job('twig-sdk-mac-build-commit') {
    label 'games-app-ios'
    using 'TEMPLATE-twig-sdk-common'
    description 'Builds all iOS artifacts upon any push to any branch in twig/sdk.'
    triggers {
        githubPush()
    }
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    scm {
        git {
            remote {
                github 'twig/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        shell 'jenkins/cmd/build-for-iOS'
    }
}


// The full nightly build for Windows
job('twig-sdk-windows-build-nightly') {
    label 'games-app'
    using 'TEMPLATE-twig-sdk-common'
    description 'Builds all Windows artifacts every night.'
    triggers {
        cron('7 0 * * *')
    }
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    scm {
        git {
            remote {
                github 'twig/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            branch 'master'
            clean true
        }
    }
    steps {
        batchFile '%WORKSPACE%\\jenkins\\cmd\\build_as_config.cmd'
    }
}


// The full nightly build for iOS
job('twig-sdk-mac-build-nightly') {
    label 'games-app-ios'
    using 'TEMPLATE-twig-sdk-common'
    description 'Builds all iOS artifacts every night.'
    triggers {
        cron('7 0 * * *')
    }
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    scm {
        git {
            remote {
                github 'twig/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            branch 'master'
            clean true
        }
    }
    steps {
        shell 'jenkins/cmd/build-for-iOS'
    }
}


// A manually triggered build of a specific branch for Windows
job('twig-sdk-windows-build-release') {
    label 'games-app'
    using 'TEMPLATE-twig-sdk-common'
    description 'Builds the specified branch for Windows and archives artifacts in AppPackages.'
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    parameters {
      stringParam 'GIT_BRANCH'
    }
    scm {
        git {
            remote {
                github 'twig/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            branch '\${GIT_BRANCH}'
            clean true
        }
    }
    steps {
        batchFile '%WORKSPACE%\\jenkins\\cmd\\build_as_config.cmd'
    }
    publishers {
        archiveArtifacts {
            pattern 'AppPackages\\*'
            onlyIfSuccessful true
        }
    }
}


// A manually triggered build of a specific branch for iOS
job('twig-sdk-mac-build-release') {
    label 'games-app-ios'
    using 'TEMPLATE-twig-sdk-common'
    description 'Builds the specified branch for iOS and archives artifacts in AppPackages.'
    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'dta_tools_deploy'
            string 'AWS_SECRET_KEY', 'dta_tools_deploy'
        }
    }
    parameters {
      stringParam 'GIT_BRANCH'
    }
    scm {
        git {
            remote {
                github 'twig/sdk', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            branch '\${GIT_BRANCH}'
            clean true
        }
    }
    steps {
        shell 'jenkins/cmd/build-for-iOS'
    }
    publishers {
        archiveArtifacts {
            pattern 'AppPackages/*'
            onlyIfSuccessful true
        }
    }
}
