if exist "C:\Program Files (x86)\Microsoft Visual Studio\2017\Community" (set VSDEVCMD_PATH="C:\Program Files (x86)\Microsoft Visual Studio\2017\Community\Common7\Tools\VsDevCmd.bat")
if exist "C:\Program Files (x86)\Microsoft Visual Studio\2017\Professional" (set VSDEVCMD_PATH="C:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\Common7\Tools\VsDevCmd.bat")
if exist "C:\Program Files (x86)\Microsoft Visual Studio\2017\Enterprise" (set VSDEVCMD_PATH="C:\Program Files (x86)\Microsoft Visual Studio\2017\Enterprise\Common7\Tools\VsDevCmd.bat")

if .%VSDEVCMD_PATH%. == .. (
	echo VSDEVCMD_PATH not set
	exit /b 1
)

pushd %~dp0

set Path=%Path:"=%;C:\NuGet

echo Restoring packages...
nuget restore %SLN_PATH%\%SLN_NAME%.sln

echo Running VsDevCmd.bat...
call %VSDEVCMD_PATH%

REM Build all platforms and configurations.
CALL "%SLN_PATH%\unittest\PS4LibTest\PreBuild.cmd" -
IF ERRORLEVEL 1 GOTO fail
CALL "%SLN_PATH%\lib\CreateSdkProjects.cmd" build
IF ERRORLEVEL 1 GOTO fail
FOR %%I IN ("Any CPU" Durango ORBIS x64) DO (
	FOR %%J IN (Debug Release) DO (
		msbuild "%SLN_PATH%\%SLN_NAME%.sln" /m /p:Platform=%%I /p:Configuration=%%J
		if ERRORLEVEL 1 goto fail
	)
)

popd

:success
echo ALL BUILD SUCCESS
exit /b 0

:fail
echo BUILD FAIL
exit /b 1
