@IF "%~1" == "" ECHO OFF
SETLOCAL

REM Validate command line and set variables.
IF NOT "%~2" == "" EXIT /B 2
SET EXIT_CODE=0
SET TWIG=AppPackages\TwitchInGames
SET ZIP="%SYSTEMDRIVE%\Program Files\7-Zip\7z.exe"

REM Create artifact directories.
CD /D "%~dp0..\.."
IF EXIST AppPackages (
	RD /Q /S AppPackages
	IF ERRORLEVEL 1 GOTO fail
)
FOR %%I IN (Debug Release) DO (
	FOR %%J IN (Durango ORBIS x64) DO (
		MD %TWIG%\%%J\%%I
		IF ERRORLEVEL 1 GOTO fail
	)
	FOR %%J IN (Android iOS x64) DO (
		MD %TWIG%\Unity\%%J\%%I
		IF ERRORLEVEL 1 GOTO fail
	)
)

REM Copy platform-agnostic artifacts.
COPY /Y lib\Shared\TwitchInGames.h %TWIG%
COPY /Y LICENSE %TWIG%

REM Copy Mac-created artifacts.
%ZIP% x -o%TWIG% mac\AppPackages\sdk.zip
IF ERRORLEVEL 1 GOTO fail

REM Copy Windows-created artifacts.
COPY /Y lib\XboxOneLib\Release\XboxOneLib.pdb Durango\Release
IF ERRORLEVEL 1 GOTO fail
FOR %%I IN (Uwp Win32) DO (
	COPY /Y lib\%%ILib\x64\Release\%%ILib.pdb x64\Release
	IF ERRORLEVEL 1 GOTO fail
)
FOR %%I IN (Debug Release) DO (
	COPY /Y ORBIS\%%I\PS4Lib.a %TWIG%\ORBIS\%%I
	IF ERRORLEVEL 1 GOTO fail
	FOR %%J IN (Dll.dll Dll.lib Dll.pdb Lib.lib Lib.pdb) DO (
		COPY /Y Durango\%%I\XboxOne%%J %TWIG%\Durango\%%I
		IF ERRORLEVEL 1 GOTO fail
		FOR %%K IN (Uwp Win32) DO (
			COPY /Y x64\%%I\%%K%%J %TWIG%\x64\%%I
			IF ERRORLEVEL 1 GOTO fail
		)
	)
	COPY /Y lib\UnityAndroid\bin\%%I\Unity.??? %TWIG%\Unity\Android\%%I
	COPY /Y lib\UnityAndroid\Android\twiglib\build\outputs\aar\twiglib-release.aar %TWIG%\Unity\Android\%%I
	IF ERRORLEVEL 1 GOTO fail
	COPY /Y lib\UnityWin32\bin\%%I\Unity.??? %TWIG%\Unity\x64\%%I
	IF ERRORLEVEL 1 GOTO fail
	FOR %%J IN (dll lib pdb) DO (
		COPY /Y x64\%%I\UnityWin32.%%J %TWIG%\Unity\x64\%%I
		IF ERRORLEVEL 1 GOTO fail
	)
)

REM Create the Zip artifact.
FOR /F "delims=" %%I IN ('TYPE version.txt') DO SET ZIP_FILE_NAME="TwitchInGames.%%I.zip"
CD AppPackages
%ZIP% a -r %ZIP_FILE_NAME% TwitchInGames
IF ERRORLEVEL 1 GOTO fail

REM Copy the Zip artifact to S3.
SET AWS_SHARED_CREDENTIALS_FILE=%SYSTEMDRIVE%\Users\jenkins\.aws\credentials
aws s3 cp %ZIP_FILE_NAME% s3://sdk-270174444876.us-west-2
REM Fall through to fail.

:fail
SET EXIT_CODE=%ERRORLEVEL%
REM Fall through to done.

:done
EXIT /B %EXIT_CODE%
