@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

SET CURL=
FOR %%I IN (curl.exe) DO SET CURL=%%~$PATH:I
IF "%CURL%" == "" SET CURL=C:\Program Files\Git\mingw64\bin\curl.exe
IF NOT EXIST "%CURL%" (
	ECHO Cannot find curl.exe
	EXIT /B 1
)

IF "%~1" == "" (
	ECHO usage: %~n0 "the cookie"
	ECHO See "https://blog.dahanne.net/2016/05/17/how-to-update-a-jenkins-job-posting-config-xml/#Security_based_on_cookies_no_user_password" for how to get the cookie.
	EXIT /B 2
)

CD /D %~dp0
FOR %%P IN (mac windows) DO (
	FOR %%T IN (commit nightly release) DO (
		ECHO Updating twig-sdk-%%P-build-%%T
		SET JOB=twig-sdk-%%P-build-%%T
		"%CURL%" -X POST "https://jenkins.internal.justin.tv/job/!JOB!/config.xml" -H "Cookie: %~1" --data-binary @!JOB!.xml
		IF ERRORLEVEL 1 GOTO fail
	)
)
EXIT /B 0

:fail
EXIT /B %ERRORLEVEL%
