@ECHO OFF
SETLOCAL

REM Check the usage.
SET ARGV1=%~1
IF /I "%ARGV1:~-1%" EQU "?" SET USAGE=1
IF /I "%ARGV1:~-1%" EQU "H" SET USAGE=1
IF /I "%ARGV1:~-4%" EQU "HELP" SET USAGE=1
IF "%USAGE%" == "1" (
	ECHO usage: %~nx0 [project [...]]
	EXIT /B 2
)

REM Set the environment variables.
SET COMPILER=vs2017
SET CMAKE_DIR=%~dp0cmake-prebuilt
SET OUTPUT_DIR=%~dp0external
SET OUTPUT_ANDROID_DIR=%~dp0UnityAndroid\Android\twiglib\src\main\cpp
SET OUTPUT_BINDING_DIR=%OUTPUT_ANDROID_DIR%\..\java\tv\twitch
SET OPENSSL_DIR=%~dp0openssl
SET SDK_DIR=%~dp0sdk
SET SDK_BINDINGS_DIR=%~dp0sdk\modules\core\core_java\bindings\tv\twitch
SET SDK_BINDINGS_CHAT_DIR=%~dp0sdk\modules\chat\chat_java\bindings\tv\twitch\chat
SET SDK_INTERNAL_DIR=%~dp0sdk_internal
SET SCRIPT=%~dpn0.js
SET JS=cscript //nologo //E:JScript

REM Collect the project options.
:loop
IF NOT "%~1" == "" (
	SET %~1=1
	SHIFT
	GOTO loop
)

REM Create the output directories, if necessary.
IF NOT EXIST "%OUTPUT_DIR%" (
	MD "%OUTPUT_DIR%"
) ELSE IF "%CLEAN%" == "1" (
	RD /Q /S "%OUTPUT_DIR%"
	MD "%OUTPUT_DIR%"
	IF ERRORLEVEL 1 GOTO fail
)
IF "%CLEAN%" == "1" IF EXIST "%OPENSSL_DIR%\openssl.vcxproj" DEL /F /Q "%OPENSSL_DIR%\openssl.vcxproj"

REM Ensure the sdk, sdk_internal, and cmake-prebuilt submodules are up to date.  Jenkins already did this.
IF "%JENKINS_SERVER_COOKIE%" == "" (
	git submodule update --init
	IF ERRORLEVEL 1 GOTO fail
)

REM Create the openssl project.
IF NOT EXIST "%OPENSSL_DIR%\openssl.vcxproj" (
	CALL :make_openssl
	IF ERRORLEVEL 1 GOTO fail
	CD /D "%OUTPUT_DIR%\.."
	%JS% CreateOpensslProject.js
	IF ERRORLEVEL 1 GOTO fail
)

REM Create the desired SDK projects.
IF ERRORLEVEL 1 GOTO fail
CD /D "%SDK_DIR%\build"
IF NOT EXIST "%OUTPUT_DIR%\Windows\sdk.sln" (
	python -B generate_twitchsdk.py --static --module=chat --module=broadcast --feature=intel-video-encoder --feature=lame-audio-encoder --platform=win32 --compiler=%COMPILER% --arch=x64 "--output-dir=%OUTPUT_DIR%\Windows" --project-name=sdk -settings TTV_USEALL_WIN32_IMPLEMENTATIONS TTV_USE_STD_OPENSSL_SOCKET TTV_USE_STD_WEBSOCKET TTV_USE_STD_THREAD_API TTV_USE_STD_BACKGROUND_EVENT_SCHEDULER
	IF ERRORLEVEL 1 GOTO fail
)
IF "%TEST%" == "1" IF NOT EXIST "%OUTPUT_DIR%\UnitTests\UnitTests.sln" (
	python -B generate_test.py --test=unit --module=chat --module=broadcast --platform=win32 --compiler=%COMPILER% --arch=x64 "--output-dir=%OUTPUT_DIR%\UnitTests" --project-name=UnitTests "--twitchsdk-dir=%OUTPUT_DIR%\Windows"
	IF ERRORLEVEL 1 GOTO fail
)
IF "%SAMPLE%" == "1" IF NOT EXIST "%OUTPUT_DIR%\Samples\Samples.sln" (
	python -B generate_sample.py --sample=cli --module=chat --module=broadcast --feature=intel-video-encoder --feature=lame-audio-encoder --platform=win32 --compiler=%COMPILER% --arch=x64 "--output-dir=%OUTPUT_DIR%\Samples" --project-name=Samples "--twitchsdk-dir=%OUTPUT_DIR%\Windows"
	IF ERRORLEVEL 1 GOTO fail
)
IF NOT EXIST "%OUTPUT_DIR%\XboxOne\sdk.sln" (
	python -B generate_twitchsdk.py --static --module=chat --platform=win32 --compiler=%COMPILER% --arch=x64 "--output-dir=%OUTPUT_DIR%\XboxOne" --project-name=sdk --target=uwp -settings TTV_USE_STD_WEBSOCKET TTV_USE_STD_THREAD_API TTV_USE_STD_BACKGROUND_EVENT_SCHEDULER
	IF ERRORLEVEL 1 GOTO fail
)
IF NOT EXIST "%OUTPUT_DIR%\PlayStation4\sdk.sln" (
	python -B generate_twitchsdk.py --cmake-no-generate --static --module=chat --platform=orbis --compiler=%COMPILER% --arch=x64 "--output-dir=%OUTPUT_DIR%\PlayStation4" --project-name=sdk "--root-dir=%SDK_DIR%_internal" -settings TWITCH_USE_ALL_ORBIS_IMPLEMENTATIONS TTV_USE_STD_MUTEX TTV_USE_STD_THREAD TTV_USE_STD_THREAD_SYNC TTV_USE_STD_THREAD_API TTV_USE_STD_SYSTEM_CLOCK TTV_USE_STD_TRACER TTV_USE_STD_BACKGROUND_EVENT_SCHEDULER TTV_USE_STD_OPENSSL_SOCKET
	IF ERRORLEVEL 1 GOTO fail
	CALL :ps4
	IF ERRORLEVEL 1 GOTO fail
)
IF NOT EXIST "%OUTPUT_ANDROID_DIR%" IF "%JAVA_HOME%" == "" (
	FOR /F "delims=" %%I IN ('DIR /B "\Program Files\Java\jdk*"') DO SET JAVA_HOME=\Program Files\%%I
)
IF NOT EXIST "%OUTPUT_ANDROID_DIR%" (
	IF "%JAVA_HOME%" == "" (
		ECHO JAVA_HOME not set
		GOTO fail
	)
	python -B generate_twitchsdk.py --dynamic --cmake-no-generate --force-monolithic-project=true --language=java --module=core --module=chat --module=broadcast --compiler=clang --platform=android --arch=x64 "--output-dir=%OUTPUT_ANDROID_DIR%" --project-name=twitchsdk -settings TTV_USEALL_ANDROID_IMPLEMENTATIONS TTV_USE_STD_THREAD_API TTV_USE_STD_MUTEX TTV_USE_STD_SYSTEM_CLOCK TTV_USE_STD_THREAD TTV_USE_STD_THREAD_SYNC TTV_USE_ANDROID_TRACER TTV_USE_STD_RAW_SOCKET TTV_USE_STD_BACKGROUND_EVENT_SCHEDULER
	IF ERRORLEVEL 1 GOTO fail
	XCOPY /s %SDK_BINDINGS_DIR% %OUTPUT_BINDING_DIR%
	XCOPY /s %SDK_BINDINGS_CHAT_DIR% %OUTPUT_BINDING_DIR%\chat
	IF ERRORLEVEL 1 GOTO fail
)

REM Update the projects for the TWIG SDK.
SET T=%TEMP%\%RANDOM%
DIR /B /S %OUTPUT_DIR%\*.vcxproj | find /I /V "cmake" > "%T%"
FOR /F "delims=" %%I IN (%T%) DO %JS% "%SCRIPT%" "%%~I"
DEL /F /Q "%T%"

REM Build the non-optional projects, if requested.
IF "%BUILD%" == "1" (
	FOR %%C IN (Debug Release) DO (
		msbuild "%OUTPUT_DIR%\Windows\sdk.vcxproj" /m /p:Platform=x64 /p:Configuration=%%C
		IF ERRORLEVEL 1 GOTO fail
		msbuild "%OUTPUT_DIR%\XboxOne\sdk.vcxproj" /m /p:Configuration=%%C
		IF ERRORLEVEL 1 GOTO fail
		msbuild "%OUTPUT_DIR%\PlayStation4\sdk.vcxproj" /m /p:Configuration=%%C
		IF ERRORLEVEL 1 GOTO fail
	)
)
ECHO Projects created.

:fail
SET EXIT_CODE=%ERRORLEVEL%
IF EXIST "%T%" DEL /F /Q "%T%"
EXIT /B %EXIT_CODE%

:make_openssl
SET CONFIGURE_PLATFORM=VC-WIN64A
SET DO_SCRIPT=do_win64a
CD /D "%OUTPUT_DIR%\..\sdk\modules\core\dependencies\openssl\src"
perl Configure %CONFIGURE_PLATFORM% no-asm no-shared no-ssl2 no-dtls -DTTV_NO_READSCREEN "--prefix=%OUTPUT_DIR%\tmp"
CALL ms\%DO_SCRIPT%
IF ERRORLEVEL 1 GOTO fail
nmake -f ms\nt.mak init
IF ERRORLEVEL 1 GOTO fail
IF EXIST "%OPENSSL_DIR%\Includes" RD /Q /S "%OPENSSL_DIR%\Includes"
MD "%OPENSSL_DIR%\Includes"
MOVE inc32 "%OPENSSL_DIR%\Includes"
MOVE tmp32 "%OPENSSL_DIR%\Includes"
EXIT /B %ERRORLEVEL%

:ps4
SETLOCAL
CD "%OUTPUT_DIR%\PlayStation4"
PATH %CMAKE_DIR%\bin;%PATH%
cmake -G "Visual Studio 14 2015 Orbis" .
EXIT /B %ERRORLEVEL%
