#include "pch.h"
#include "Internal.h"

using namespace TwitchInGames;

ClientAuth::ClientAuth() {}

ClientAuth::~ClientAuth() {}

std::future<tstring> ClientAuth::StartAuth(string_t clientId, string_t redirectUri, std::vector<string_t> const& scopes) {
	// Extract the scheme from the redirect URI.
	auto const* p= _tcschr(redirectUri, _T(':'));
	if(p == nullptr || p == redirectUri) {
		throw TwitchException(FromPlatformError(ERROR_BAD_ARGUMENTS));
	}
	tstring scheme(redirectUri, p);

	// Start the implicit flow authentication (flow two).
	TwitchInGames::tstring state;
	return BrowserAuth::Launch(clientId, redirectUri, _T("token"), scopes, state, scheme.c_str());
}

void ClientAuth::Cancel() {
	Stop(_T(""));
}
