#include "pch.h"
#include <libnetctl.h>
#include "Internal.h"

#pragma comment(lib, "libSceNetCtl_stub_weak.a")

using namespace TwitchInGames;

namespace {
	char const* const sdkPlatform= "PlayStation 4";
	char const* const sdkRuntime= "C++";

	tstring GetApplicationName() {
		char buf[33];
		if(scePthreadGetname(scePthreadSelf(), buf) == SCE_OK) {
			return buf;
		}
		return tstring();
	}

	tstring GetDeviceId() {
		// TODO:  document this TRC requirement.
		// https://ps4.siedev.net/resources/documents/TRC/2018.02/TRC/R4081.html
		union {
			SceNetCtlInfo info;
			unsigned short n[3];
		} u{};
		static_assert(sizeof(u.info.ether_addr) == sizeof(u.n), "unexpected size");
		if(sceNetCtlGetInfo(SCE_NET_CTL_INFO_ETHER_ADDR, &u.info) == 0 && (u.n[0] || u.n[1] || u.n[2])) {
			TCHAR deviceId[37];
			_stprintf_s(deviceId, _T("00000000-%04x-%04x-%04x-000000000000"), u.n[0], u.n[1], u.n[2]);
			return deviceId;
		}
		return tstring();
	}
}

#include "Analytics.inl"
