#include "pch.h"
#include "Internal.h"

using namespace TwitchInGames;

TwitchException::TwitchException(int errorCode) noexcept : errorCode(errorCode) {
	if(errorCode == 400) {
		strcpy_s(description, "Authentication or authorization error");
	} else {
#if defined(_XBOX_ONE)
		sprintf_s(description, "Error %d (%#x)",
			HRESULT_FACILITY(errorCode) == FACILITY_WIN32 ? HRESULT_CODE(errorCode) : errorCode, errorCode);
#elif defined(_WIN32)
		auto const result= errorCode < 0 ? FormatMessageA(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			nullptr, HRESULT_CODE(errorCode), 0, description, _countof(description), nullptr) : 0;
		if(result == 0) {
			sprintf_s(description, "Error %d (%#x)",
				HRESULT_FACILITY(errorCode) == FACILITY_WIN32 ? HRESULT_CODE(errorCode) : errorCode, errorCode);
		}
#else
		sprintf_s(description, "Error %d (%#x)", errorCode, errorCode);
#endif
	}
}

char const* TwitchException::what() const noexcept {
	return description;
}
