#pragma once

#ifdef _WIN32
# define NOMINMAX
# include "targetver.h"

# define _CRT_RAND_S
# ifdef _XBOX_ONE
#  include <xdk.h>
#  if _XDK_EDITION == 180201
#   define _SILENCE_CXX17_CODECVT_HEADER_DEPRECATION_WARNING
#  endif
#  if _XDK_EDITION >= 170607 && _XDK_EDITION <= 171101
#   pragma warning(disable: 5040) // dynamic exception specifications are valid only in C++14 and earlier; treating as noexcept(false)
#  endif
#  include <winrt/Windows.System.h>
#  include <winrt/Windows.UI.Core.h>
#  include <winrt/Windows.Foundation.h>
#  if _XDK_EDITION >= 170607 && _XDK_EDITION <= 171101
#   pragma warning(default: 5040)
#  endif
# else
#  define WIN32_LEAN_AND_MEAN
# endif

// Windows header files
# include <windows.h>
# include <WinSock2.h>
# if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)
#  include <winhttp.h>
#  define ERROR_INVALID_RESPONSE ERROR_WINHTTP_INVALID_SERVER_RESPONSE
# else
#  define ERROR_INVALID_RESPONSE 12152
# endif
# include <tchar.h>
# define FromPlatformError HRESULT_FROM_WIN32
#elif defined(__ORBIS__) || defined(__APPLE__)
# ifdef __ORBIS__
// PS4 header files
#  include <kernel.h>
#  include <libsysmodule.h>
#  include <libnet/errno.h>
# endif

// C++ standard library header files
# include <iostream>

# define _countof(a) (sizeof(a) / sizeof((a)[0]))
# define _T(s) (s)
# define _istalnum isalnum
# define _stprintf_s sprintf_s
# define _stscanf_s sscanf_s
# define _tcschr strchr
# define _totlower tolower
# define _ttoi atoi
# define UNREFERENCED_PARAMETER(p) ((void)p)
# ifdef __APPLE__
#  define strcpy_s strcpy
#  define sprintf_s sprintf
#  define _tcsdup strdup
#  define FromPlatformError(error) (0x80000000 | (error))
# else
#  define FromPlatformError(error) SCE_ERROR_MAKE_ERROR(0, error)
# endif

using TCHAR= char;
using LPTSTR= TCHAR*;
using LPCTSTR= TCHAR const*;

// Missing error code macros
# define ERROR_SUCCESS 0
# define ERROR_BAD_ARGUMENTS EINVAL
# define ERROR_CONNECTION_ABORTED ECONNABORTED
# define ERROR_CONNECTION_INVALID ENOTCONN
# define ERROR_CONNECTION_REFUSED ECONNREFUSED
# define ERROR_INVALID_ACCESS EPERM
# define ERROR_INVALID_FUNCTION ENOSYS
# define ERROR_INVALID_OPERATION EOPNOTSUPP
# define ERROR_INVALID_RESPONSE EBADMSG
# define ERROR_REQUEST_ABORTED ECANCELED
# define ERROR_SYSTEM_SHUTDOWN ESHUTDOWN
#else
# error "unknown platform"
#endif

// CAPE SDK pch.h header files
#include <limits.h>
#include <stdint.h>
#include <cassert>
#include <cmath>
#include <cstdlib>
#include <algorithm>
#include <atomic>
#include <chrono>
#include <codecvt>
#include <deque>
#include <fstream>
#include <iomanip>
#include <queue>
#include <random>
#include <regex>
#include <sstream>
#include <unordered_map>

#ifdef _UNICODE
# define to_tstring std::to_wstring
using tistream= std::wistream;
using tistringstream= std::wistringstream;
using tofstream= std::wofstream;
using tostream= std::wostream;
using tostringstream= std::wostringstream;
using tregex= std::wregex;
using tstringstream= std::wstringstream;
#else
# define to_tstring std::to_string
using tistream= std::istream;
using tistringstream= std::istringstream;
using tofstream= std::ofstream;
using tostream= std::ostream;
using tostringstream= std::ostringstream;
using tregex= std::regex;
using tstringstream= std::stringstream;
#endif

#include "Internal.h"
