/*
 * Twitch Android App
 * Copyright (c) 2012-2017 Twitch Interactive, Inc.
 */

package tv.twitch.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import tv.twitch.util.CollectionUtils;
import tv.twitch.util.ParcelableField;
import tv.twitch.util.ParcelableHelper;
import tv.twitch.chat.ChatMessageBadge;

/**
 * Adapted by loohill on 05/09/18
 * Last sync: 05/09/18
 * Source: twitch-apps/twitch-android/blob/master/Twitch/src/main/java/tv/twitch/android/models/UserBadgeModel.java
 */

public class UserBadgeModel implements Parcelable {
	private static final ParcelableHelper<UserBadgeModel> sParcelHelper = new ParcelableHelper<>(UserBadgeModel.class);

	@ParcelableField @SerializedName("_id") public String id;
	@ParcelableField public String version;

	@NonNull
	public static String toStringForTracking(@Nullable List<UserBadgeModel> userBadges) {
		if (CollectionUtils.isEmpty(userBadges)) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		for (UserBadgeModel userBadge : userBadges) {
			sb.append(userBadge.id).append(",");
		}
		// Use substring to remove the last comma
		return sb.toString().substring(0, sb.length() - 1);
	}

	public UserBadgeModel() {

	}

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		sParcelHelper.pack(this, dest);
	}

	public static final Parcelable.Creator<UserBadgeModel> CREATOR = new Parcelable.Creator<UserBadgeModel>() {
		@Override
		public UserBadgeModel createFromParcel(Parcel in) {
			UserBadgeModel model = sParcelHelper.unpack(in);
			return model;
		}

		@Override
		public UserBadgeModel[] newArray(int size) {
			return new UserBadgeModel[size];
		}
	};

	public ChatMessageBadge toChatMessageBadge() {
		ChatMessageBadge chatMessageBadge = new ChatMessageBadge();
		chatMessageBadge.name = id;
		chatMessageBadge.version = version;
		return chatMessageBadge;
	}
}
