package tv.twitch.sdk;

import android.content.Context;

//import com.getkeepsafe.relinker.ReLinker;
//
//import tv.twitch.CoreErrorCode;
//import tv.twitch.ErrorCode;
import tv.twitch.Library;

import com.unity3d.player.*;

/**
 * Adapted by loohill on 05/04/18
 * Last sync: 05/04/18
 * Source: twitch-apps/twitch-android/blob/master/Twitch/src/main/java/tv/twitch/android/sdk/SDKLibrary.java
 * Changes:
 *** TODO ReLinker doesn't work under Unity.
 *** Removed BuildConfig. ref: https://stackoverflow.com/questions/21365928;
 *** Uses UnityPlayer.currentActivity.getApplication() as Context for SingletonHolder instead of TwitchApplication.get();
 *
 */

public class SDKLibrary extends Library {

    public static SDKLibrary getInstance() {
        return SingletonHolder.Instance;
    }

    //NOTE: if using multi-dex, be wary of NoClassDefError: https://code.google.com/p/android/issues/detail?id=162774
    private static class SingletonHolder {
        private static final SDKLibrary Instance = new SDKLibrary(UnityPlayer.currentActivity.getApplication());
    }

    private Context mContext;
    private SDKLibrary(Context context) {
        mContext = context;
    }

    public String getVersion(){
        return GetVersionString();
    }

//    @Override
//    public ErrorCode loadLibrary(String libraryName) {
//        // https://github.com/KeepSafe/ReLinker#recursive-loading
//        // On older versions of Android, the system's library loader may fail to resolve intra-library
//        // dependencies. In this instance, ReLinker can resolve those dependencies for you. This will
//        // recursively load all libraries defined as "needed" by each library.
//        ReLinker.recursively().loadLibrary(mContext, libraryName);
//        return CoreErrorCode.TTV_EC_SUCCESS;
//    }
}
