/*
 * Twitch Android App
 * Copyright (c) 2012-2017 Twitch Interactive, Inc.
 */

package tv.twitch.util;

import android.support.annotation.Nullable;

import java.util.List;
import java.util.Map;

/**
 * Adapted by loohill on 05/09/18
 * Last sync: 05/09/18
 * Source: twitch-apps/twitch-android/blob/master/Twitch/src/main/java/tv/twitch/android/util/CollectionUtils.java
 */

public class CollectionUtils {

	public static <T> int getSize(@Nullable List<T> list) {
		return list == null ? 0 : list.size();
	}

	public static boolean isEmpty(@Nullable List list) {
		return list == null || list.size() == 0;
	}

	public static boolean isEmpty(@Nullable Map map) {
		return map == null || map.size() == 0;
	}
}
