package tv.twitch.util;

import android.support.annotation.NonNull;

import java.util.Locale;

/**
 * Adapted by loohill on 05/03/18
 * Last sync: 05/03/18
 * Source: twitch-android/Twitch/src/main/java/tv/twitch/android/util/LocaleUtil.java
 */

public class LocaleUtil {

    @NonNull private Locale mDefaultLocale;

    @NonNull
    public static LocaleUtil create() {
        return new LocaleUtil(Locale.getDefault());
    }

    private LocaleUtil(Locale defaultLocale) {
        mDefaultLocale = defaultLocale;
    }

    @NonNull
    public String getBroadcasterLanguageCodeFromLocale() {
        String languageCode = mDefaultLocale.getLanguage(); // ISO639-1 format
        //NOTE: for now, we are going to ignore regions (i.e. zh-tw and zh-hk map to zh)
//		String countryCode = Locale.getDefault().getCountry().toLowerCase();
//		switch (countryCode) {
//			case "br":
//			case "hk":
//			case "tw":
//			case "mx":
//				languageCode += "-" + countryCode;
//				break;
//		}
        return languageCode;
    }

    @NonNull
    public String getLoginPageLanguageCodeFromLocale() {
        String languageCode = Locale.getDefault().getLanguage(); // ISO639-1 format
        if (languageCode.equals("nb")) { // special case for norwegian
            languageCode = "no";
        }
        String countryCode = Locale.getDefault().getCountry().toLowerCase();
        switch (countryCode) { // only append countryCode in these cases
            case "br":
            case "tw":
            case "cn":
                languageCode += "-" + countryCode;
                break;
        }
        return languageCode;
    }

    @NonNull
    public String getApiLanguageCodeFromLocale() {
        return mDefaultLocale.getLanguage() + "-" + mDefaultLocale.getCountry().toLowerCase();
    }
}
