/*
 * Twitch Android App
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 */

package tv.twitch.util;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextUtils;

import tv.twitch.twiglib.R;

import com.unity3d.player.*;
/**
 * Adapted by loohill on 05/09/18
 * Last sync: 05/09/18
 * Source: twitch-apps/twitch-android/blob/master/Twitch/src/main/java/tv/twitch/android/util/StringFormatter.java
 * Changes:
 *** Replace path of R.java to ours;
 */
public class StringFormatter {

    private static StringFormatter getInstance() {
        return SingletonHolder.Instance;
    }

    //NOTE: if using multi-dex, be wary of NoClassDefError: https://code.google.com/p/android/issues/detail?id=162774
    private static class SingletonHolder {
        private static final StringFormatter Instance = new StringFormatter(UnityPlayer.currentActivity.getApplication());
    }

    private Resources res;
    private StringFormatter(Context context) {
        res = context.getResources();
    }

    public static CharSequence playingGameWithTitleCase(String game, boolean titlecase) {
        return Html.fromHtml(unformattedPlayingGameWithTitleCase(game, titlecase));
    }

    public static String unformattedPlayingGameWithTitleCase(String game, boolean titlecase) {
        Resources res = getInstance().res;
        String title;
        if (game.equalsIgnoreCase("Creative")) {
            title = titlecase ? res.getString(R.string.being_creative_uppercase) : res.getString(R.string.being_creative_lowercase);
        } else {
            title = titlecase ? res.getString(R.string.playing_game_uppercase, game) : res.getString(R.string.playing_game_lowercase, game);
        }
        return title;
    }

    public static CharSequence channelPlayingGame(String channel, String game) {
        return channelPlayingGame(channel, game, true);
    }

    public static CharSequence channelPlayingGame(String channel, String game, boolean withBoldFormatting) {
        Resources res = getInstance().res;
        String title;
        if (game.equalsIgnoreCase("Creative")) {
            title = res.getString(withBoldFormatting ? R.string.channel_being_creative : R.string.channel_being_creative_no_formatting, channel, game);
        } else {
            title = res.getString(withBoldFormatting ? R.string.channel_playing_game : R.string.channel_playing_game_no_formatting, channel, game);
        }

        return withBoldFormatting ? Html.fromHtml(title) : title;
    }

    @NonNull
    public static String internationalizedDisplayName(String displayName, String name) {

        // Check if displayname is not in the ASCII 0-127 range. If not, show: "displayname (name)"
        if (TextUtils.isEmpty(displayName)) {
            if (TextUtils.isEmpty(name)) {
                return "";
            } else {
                return name;
            }
        }

        if (isAscii0To127(displayName)) {
            return displayName;
        } else {
            return getInstance().res.getString(R.string.displayname_and_username, displayName, name);
        }
    }

    private static boolean isAscii0To127(String string) {
        for (int i = 0; i < string.length(); i++) {
            char c = string.charAt(i);
            if (c > 127) {
                return false;
            }
        }

        return true;
    }
}
