﻿using System;
using System.Collections;
using System.Linq;
using UnityEngine;

namespace TwitchInGames {
    public partial class Chat {
        public class Channel {   
            public delegate void ReceiveCallback(Channel channel, string userName, string message);

            public string Name { get; }
            public ReceiveCallback receiveCallback { get; }
            private Chat chat;

            internal Channel(Chat chat, string name, ReceiveCallback receiveCallback) {
                Name = name;
                this.chat = chat;
                this.receiveCallback = receiveCallback;
            }

            public Coroutine<object> Depart() {
                return new Coroutine<object>(InternalDepart());
            }

            private IEnumerator InternalDepart() {
                chat.chatJavaObject.Call("Depart", this.Name);
                yield return new WaitUntil(() => !chat.chatJavaObject.Call<bool>("hasJoin", this.Name));
                chat.channels.Remove(this.Name);
            }

            public Coroutine<object> SendLine(string message) {
                return new Coroutine<object>(InternalSendLine(message));
            }

            public IEnumerator InternalSendLine(string message) {
                chat.chatJavaObject.Call("SendLine", this.Name, message);
                yield return null;
            }
        }
    }
}
