﻿using System;
using System.Globalization;

namespace TwitchInGames {
    internal static class Utility {
        internal static void CheckArgument(string name, string value) {
            if(String.IsNullOrEmpty(value)) {
                var message = $"The {name} is null or empty";
                throw new ArgumentException(message, name);
            }
        }

        internal static void CheckArgument(string name, object value) {
            if(value == null) {
                throw new ArgumentNullException(name);
            }
        }

        internal static string FormatMessage(string component, string message) {
            return $"[{component}] {message}";
        }

        internal static DateTime StringToDateTime(string s) {
            int i = s.IndexOf('T');
            s = s.Substring(0, i) + ' ' + s.Substring(i + 1);
            var d = DateTime.ParseExact(s, "u", CultureInfo.InvariantCulture, DateTimeStyles.AssumeUniversal);
            return d;
        }
    }
}
