#pragma once

#include "TwitchInGames.h"

#ifndef _WIN32
using HRESULT = int;

static inline HRESULT HRESULT_FROM_WIN32(int errorCode) {
	return errorCode < 0 ? errorCode : 0x80070000 | (errorCode & 0xffff);
}

# define E_FAIL 0x80004005
# define ERROR_ACCESS_DENIED 5
# define S_OK 0
#endif

namespace TwitchInGames {
	extern "C" {
		using ChatChannelReceiveCallback = void(*)(Chat::Channel& channel, string_t userName, string_t message);

		TWITCH_SDK_DLL_API Chat* CreateChat();
		TWITCH_SDK_DLL_API void DeleteChat(Chat*& chat);
		TWITCH_SDK_DLL_API HRESULT SignInChat(Chat* chat, string_t clientId, string_t token, string_t& login);
		TWITCH_SDK_DLL_API HRESULT SignOutChat(Chat* chat);
		TWITCH_SDK_DLL_API HRESULT JoinChannel(Chat* chat, string_t channelName, ChatChannelReceiveCallback receiveCallback, std::shared_ptr<Chat::Channel>*& channel);
		TWITCH_SDK_DLL_API void DepartChannel(std::shared_ptr<Chat::Channel>*& channel);
		TWITCH_SDK_DLL_API HRESULT SendLineToChannel(std::shared_ptr<Chat::Channel>* channel, string_t message);
	}
}
