#include "pch.h"
#include <objbase.h>
#include "ClientAuth_.h"

TWITCH_SDK_DLL_API TwitchInGames::ClientAuth* TwitchInGames::CreateClientAuth() {
	return new ClientAuth();
}

TWITCH_SDK_DLL_API TwitchInGames::string_t TwitchInGames::DoClientAuth(ClientAuth* clientAuth, string_t clientId, string_t redirectUri, string_t scopes) {
	// Execute ClientAuth::StartAuth synchronously.
	auto task = clientAuth->StartAuth(clientId, redirectUri, { scopes });
	auto result= task.get();

	// Return the result as a .NET string.
	auto const n= (result.size() + 1) * sizeof(result[0]);
	auto* rv= static_cast<LPTSTR>(CoTaskMemAlloc(n));
	memcpy_s(rv, n, result.c_str(), n);
	return rv;
}

TWITCH_SDK_DLL_API void TwitchInGames::CancelClientAuth(ClientAuth* clientAuth) {
	clientAuth->Cancel();
}

TWITCH_SDK_DLL_API void TwitchInGames::DeleteClientAuth(ClientAuth*& clientAuth) {
	delete clientAuth;
	clientAuth= nullptr;
}
