#include <cctype>
#include <cstdlib>
#include <algorithm>
#include <string>
#include "ClientAuth.h"

void* CreateClientAuth(int left, int top, int right, int bottom) {
	void* clientAuth= ClientAuth_Init(false);
	ClientAuth_SetMargins(clientAuth, left, top, right, bottom);
	return clientAuth;
}

void StartClientAuth(void* clientAuth, char const* url, char const* scheme) {
	// Show the Web view.
	ClientAuth_SetVisibility(clientAuth, true);

	// Open the URL in the Web view.
	ClientAuth_LoadURL(clientAuth, url, scheme);
}

char* GetClientAuthResponseUri(void* clientAuth) {
	return ClientAuth_GetResponseUri(clientAuth);
}

void CancelClientAuth(void* clientAuth) {
	ClientAuth_Cancel(clientAuth);
}

void DeleteClientAuth(void*& clientAuth) {
	ClientAuth_Destroy(clientAuth);
	clientAuth= nullptr;
}

void ClearClientAuthCookies() {
	ClientAuth_ClearCookies();
}
