// These functions are used to bridge C++ and Objective C.
extern "C" {
	void* ClientAuth_Init(bool transparent);
	void ClientAuth_Destroy(void* instance);
	void ClientAuth_SetMargins(void* instance, int left, int top, int right, int bottom);
	void ClientAuth_SetVisibility(void* instance, bool visibility);
	void ClientAuth_LoadURL(void* instance, char const* url, char const* scheme);
	char* ClientAuth_GetResponseUri(void* instance);
	void ClientAuth_Cancel(void* instance);
	void ClientAuth_ClearCookies();
}

// These functions are exported to C#.
extern "C" {
	void* CreateClientAuth(int left, int top, int right, int bottom);
	void StartClientAuth(void* clientAuth, char const* url, char const* scheme);
	char* GetClientAuthResponseUri(void* clientAuth);
	void CancelClientAuth(void* clientAuth);
	void DeleteClientAuth(void*& clientAuth);
	void ClearClientAuthCookies();
}
