#include <TargetConditionals.h>
#include <future>
#include <string>
#define UNREFERENCED_PARAMETER(p) ((void)(p))
#define _T(s) s
#include "Internal.h"

using TCHAR= char;
using LPTSTR= TCHAR*;
using LPCTSTR= TCHAR const*;

#include "../../Shared/Internal.h"
#include "ClientAuth.h"
#include "../../external/twitchsdk.h"

using namespace TwitchInGames;

namespace {
	char const* sdkPlatform= "iOS Unity";
	char const* sdkRuntime= "C++";
	tstring platformApplicationName;

	tstring GetApplicationName() {
		return platformApplicationName;
	}

	tstring GetDeviceId() {
		TTV_InitializeLibrary();
		unsigned short macAddress[3];
		GetMacAddress(macAddress);
		TCHAR deviceId[37];
		sprintf(deviceId, "aaaaaaaa-%04x-%04x-%04x-aaaaaaaaaaaa",
			macAddress[0], macAddress[1], macAddress[2]);
		return deviceId;
	}
}

extern "C" void SetApplicationName(char const* s) {
	platformApplicationName= s;
}

#include "../../Shared/Analytics.inl"
