#include "pch.h"
#include "Internal.h"

using namespace TwitchInGames;

ClientAuth::ClientAuth() {}

ClientAuth::~ClientAuth() {}

std::future<tstring> ClientAuth::StartAuth(string_t clientId, string_t redirectUri, std::vector<string_t> const& scopes) {
	// Start the authentication.
	return BrowserAuth::Launch(clientId, redirectUri, _T("token"), scopes, state);
}

#pragma warning(disable: 4458) // declaration of 'token' hides class member
// This is an extraneous warning since the class member "token" is private in
// the base class.
void ClientAuth::Finish(tstring activationUri) {
	// Validate the response, check the state, and extract the token.
	tstring token;
	auto const i= activationUri.find(L'#');
	if(i != activationUri.npos) {
		activationUri.erase(0, i + 1);
		auto returnedState= ExtractToken(activationUri, _T("state"));
		if(returnedState == state) {
			token= ExtractToken(activationUri, _T("access_token"));
		}
	}

	// Set this session's token.
	Stop(token.c_str());
}
#pragma warning(default: 4458)

void ClientAuth::Cancel() {
	Stop(_T(""));
}
