#include "pch.h"
#include "Internal.h"

using namespace TwitchInGames;

namespace {
	char const* const sdkPlatform= PLATFORM;
	char const* const sdkRuntime= "C++/WinRT";
	tstring nullGuid= _T("00000000-0000-0000-0000-000000000000");

	tstring GetApplicationName() {
		auto* commandLine= GetCommandLine();
		if(commandLine[0] == _T('"')) {
			++commandLine;
			auto* quote= _tcschr(commandLine, _T('"'));
			if(quote != nullptr) {
				*quote= _T('\0');
			}
		} else {
			auto* space= _tcschr(commandLine, _T(' '));
			if(space != nullptr) {
				*space= _T('\0');
			}
		}
		auto const* separator= _tcsrchr(commandLine, _T('\\'));
		if(separator != nullptr) {
			return tstring(separator + 1);
		}
		return commandLine;
	}

	tstring GetDeviceId() {
		auto ecdi = ref new Windows::Security::ExchangeActiveSyncProvisioning::EasClientDeviceInformation();
		if(ecdi != nullptr) {
			tstring deviceId= ecdi->Id.ToString()->Data();
			if(deviceId != nullGuid) {
				_tcslwr_s(&deviceId[0], deviceId.size());
				return deviceId;
			}
		}
		return tstring();
	}
}

#include "Analytics.inl"
