#include "pch.h"
#include "Internal.h"

using namespace TwitchInGames;

BrowserAuth::BrowserAuth() : isReady(false) {}

BrowserAuth::~BrowserAuth() {}

std::future<tstring> BrowserAuth::Launch(string_t url, tstring const& state, string_t scheme) {
	UNREFERENCED_PARAMETER(scheme);
	UNREFERENCED_PARAMETER(state);
	auto uri= winrt::Windows::Foundation::Uri(url);
	winrt::Windows::System::Launcher::LaunchUriAsync(uri);
	auto fn= [this] {
		TokenLock lock(tokenAccessor);
		cv.wait(lock, [this] { return isReady; });
		return token;
	};
	return std::async(std::launch::deferred, fn);
}

void BrowserAuth::Stop(string_t token_) {
	// Resolve the future returned from Launch.
	TokenLock lock(tokenAccessor);
	token= token_;
	isReady= true;
	cv.notify_all();
}
