#include "pch.h"
#include <winrt/Windows.Networking.Connectivity.h>
#include "Internal.h"

using namespace TwitchInGames;

namespace {
	char const* const sdkPlatform= PLATFORM;
	char const* const sdkRuntime= "C++";
	GUID nullGuid;

	tstring GetApplicationName() {
		auto* commandLine= GetCommandLine();
		if(commandLine[0] == _T('"')) {
			++commandLine;
			auto* quote= _tcschr(commandLine, _T('"'));
			if(quote != nullptr) {
				*quote= _T('\0');
			}
		} else {
			auto* space= _tcschr(commandLine, _T(' '));
			if(space != nullptr) {
				*space= _T('\0');
			}
		}
		auto const* separator= _tcsrchr(commandLine, _T('\\'));
		if(separator != nullptr) {
			return tstring(separator + 1);
		}
		return commandLine;
	}

	tstring GetDeviceId() {
		try {
			auto profiles= winrt::Windows::Networking::Connectivity::NetworkInformation::GetConnectionProfiles();
			for(auto profile : profiles) {
				auto id= profile.NetworkAdapter().NetworkAdapterId();
				if(id != nullGuid) {
					TCHAR deviceId[39];
					if(StringFromGUID2(id, deviceId, _countof(deviceId))) {
						deviceId[37]= _T('\0');
						_tcslwr_s(deviceId);
						return deviceId + 1;
					}
				}
			}
		} catch(...) {
			// Ignore errors.
		}
		return _T("");
	}
}

#include "Analytics.inl"
