#include "pch.h"
#include "../../lib/Shared/Internal.h"
#include "Utilities.h"
#ifndef GTEST_OS_WINDOWS
# include "FollowTest.h"
#endif

using namespace TwitchInGames;
using namespace Utilities;

TEST(FollowTest, FetchFollowers_Success) {
	FollowersRequest followersRequest;
	auto followersResponse = followersRequest.Fetch(clientId, token, userId).get();
	EXPECT_NE(followersResponse.Cursor, _T(""));
	EXPECT_GE(followersResponse.Followers.size(), 0u);
	EXPECT_GE(followersResponse.TotalCount, 0u);

	for(auto const& follower : followersResponse.Followers) {
		EXPECT_NE(follower.UserId, _T(""));
		EXPECT_NE(follower.FollowedAt, NULL);
	}
}

TEST(FollowTest, FetchFollowers_Fail) {
	FollowersRequest followersRequest;
	EXPECT_ANY_THROW(followersRequest.Fetch(clientId, token, userId_Invalid).get());
}
