#include "pch.h"
#include "twitchsdk/core/json/reader.h"
#include "twitchsdk/core/json/writer.h"
#ifndef GTEST_OS_WINDOWS
# include "JsonTest.h"
#endif

using namespace ttv;

TEST(JsonTest, ReadJsonFile) {
	std::ifstream sampleTestInfo("../../unittest/Win32LibTest/data/TestInfo.json");
	EXPECT_TRUE(sampleTestInfo.is_open());

	std::string data((std::istreambuf_iterator<char>(sampleTestInfo)), std::istreambuf_iterator<char>());
	json::Reader reader;

	json::Value root;
	EXPECT_TRUE(reader.parse(data, root));
	EXPECT_TRUE(root["array"].isArray());
	EXPECT_TRUE(root["array_empty"].isArray());
	EXPECT_TRUE(root["array"].isNonNullArray());
	EXPECT_TRUE(root["array_empty"].isNonNullArray());
	EXPECT_FALSE(root["array_null"].isNonNullArray());
	EXPECT_FALSE(root["array"].empty());
	EXPECT_TRUE(root["array_empty"].empty());

	size_t i = 0;
	EXPECT_TRUE(root["array"][i].isObject());
	EXPECT_TRUE(root["array"][i].isNonNullObject());
	EXPECT_FALSE(root["array"][i].empty());
	EXPECT_FALSE(root["array"][i].isNull());
	i++;
	EXPECT_TRUE(root["array"][i].isObject());
	EXPECT_TRUE(root["array"][i].isNonNullObject());
	EXPECT_TRUE(root["array"][i].empty());
	EXPECT_FALSE(root["array"][i].isNull());
	i++;
	EXPECT_TRUE(root["array"][i].isNull());

	i = 0;
	json::Value info = root["array"][i];

	EXPECT_TRUE(info["bool_true"].isBool());
	EXPECT_EQ(info["bool_true"].asBool(), true);
	EXPECT_TRUE(info["bool_false"].isBool());
	EXPECT_EQ(info["bool_false"].asBool(), false);
	EXPECT_TRUE(info["number"].isNumeric());
	EXPECT_EQ(info["number"].asInt(), 42);
	EXPECT_EQ(info["number"].asUInt(), 42u);
	EXPECT_TRUE(info["string"].isString());
	EXPECT_EQ(info["string"].asString(), "Don't Panic");
	EXPECT_TRUE(info["null"].isNull());
	EXPECT_TRUE(info["random"].isNull());

}

TEST(JsonTest, WriteJsonFile) {
	json::Value data;
	data["number"] = 42;
	data["string"] = "Don't Panic";
	data["bool"] = true;

	json::FastWriter fastWriter;
	std::string fastWriterStr = fastWriter.write(data); 
	EXPECT_EQ(fastWriterStr, "{\"bool\":true,\"number\":42,\"string\":\"Don't Panic\"}\n");

	json::StyledWriter styledWriter;
	std::string styledWriterStr = styledWriter.write(data);
	EXPECT_EQ(styledWriterStr, "{\n   \"bool\" : true,\n   \"number\" : 42,\n   \"string\" : \"Don't Panic\"\n}\n");	
}
