#include "pch.h"
#include "../../lib/Shared/Internal.h"
#include "../../lib/Shared/Socket.h"
#ifndef GTEST_OS_WINDOWS
# include "SocketTest.h"
#endif

using namespace TwitchInGames;

TEST(SocketTest, Connect_Success) {
	Socket socket;
	socket.Connect(_T("google.com"), 80);
	char const request[]= "GET / HTTP/1.1\r\nUser-Agent: curl/7.16.3 libcurl/7.16.3 OpenSSL/0.9.7l zlib/1.2.3\r\nHost: www.example.com\r\nAccept-Language: en\r\n\r\n";
	size_t const n= sizeof(request) - 1;
	EXPECT_EQ(socket.SendAll(request, n), static_cast<int>(n));
	std::vector<char> response(99);
	EXPECT_EQ(socket.ReceiveAll(response), static_cast<int>(response.size()));
	tstring const _404= _T("HTTP/1.1 404 Not Found\r\n");
	EXPECT_EQ(tstring(response.cbegin(), response.cbegin() + _404.size()), _404);
}
