#include "pch.h"
#include "../../lib/Shared/Internal.h"
#ifndef GTEST_OS_WINDOWS
# include "TokenTest.h"
#endif

using namespace TwitchInGames;

TEST(TokenTest, ExtractToken_Success) {
	// This is an example of the result of flow two.
	tstring const expectedToken= _T("kevsj4jgjdz56agd1poxp8srzg5mr3");
	tstring const expectedState= _T("jbDOlOhKnJPccFongiHBDHbiCjahgIHJ");
	tstring const text= _T("access_token=") + expectedToken + _T("&scope=user%3Aread%3Aemail&state=") + expectedState;
	auto actualToken= ExtractToken(text, _T("access_token"));
	EXPECT_EQ(actualToken, expectedToken);
	auto actualState= ExtractToken(text, _T("state"));
	EXPECT_EQ(actualState, expectedState);
}

TEST(TokenTest, ExtractToken_Failure) {
	tstring const text= _T("twig://twig.tv/auth?error=redirect_mismatch&error_description=Parameter+redirect_uri+does+not+match+registered+URI&state=kdpBfFoiJbjpFcCcilhghAMPEfPFMinp");
	auto result= ExtractToken(text);
	EXPECT_TRUE(result.empty());
}
